IF EXISTS ( SELECT * FROM sysobjects WHERE  id = object_id(N'CP_Ventas_por_Producto') and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CP_Ventas_por_Producto 
END
GO


CREATE  PROCEDURE [dbo].[CP_Ventas_por_Producto]
	@pFecha_Desde			DATETIME,
	@pFecha_Hasta			DATETIME,
	@pId_Familia               Int,
	@pId_Sucursal              Int,
	@pId_Proveedor             Int,
	@pId_Vendedor              VARCHAR(20)

AS
SET NOCOUNT ON

/*Declaracion Variables Locales*/

DECLARE @Mensaje			VARCHAR(100)
		,@UltError			INT
		,@Id_Trans			INT
		,@Id_Cliente		INT
		,@Importe			DECIMAL(16,2)
		,@Email_Cob			VARCHAR(256)
		,@Id_Trans_Rec		INT
		,@CursorOpen        INT
		,@Flag_Cbte_Tipo	SMALLINT
		,@Periodo           DATE 
		,@Existe      	    SMALLINT
		,@sql				VARCHAR(MAX)
		,@Venta_Total       DECIMAL(20,2)


					
BEGIN 

	UPDATE cbtes_tipos	SET id_sucursal		= 0		WHERE id_sucursal is null
	UPDATE productos	SET id_familia		= 0		WHERE id_familia is null
	UPDATE cbtes_tipos	SET id_unid_negocio	= ''	WHERE id_unid_negocio is null
    UPDATE PRODUCTOS 	SET ID_MONEDA_C 	= 'PES' WHERE ID_MONEDA_C = '' OR ID_MONEDA_C IS NULL
   
	UPDATE cbtes SET Porc_Bonificacion = 0 
			FROM cbtes c, cbtes_tipos t 
			WHERE c.id_tipo_cbte = t.id_tipo_cbte
			AND t.compromete_factura IN (1,-1)
			AND c.Porc_Bonificacion IS NULL
			AND C.FECHA >= @pFecha_Desde 
            AND C.FECHA < dateadd(dd,1,@pFecha_Hasta)

	UPDATE cbtes_items SET Cantidad = 0 
			FROM cbtes_items i, cbtes c, cbtes_tipos t 
			WHERE i.id_trans = c.id_trans
			AND c.id_tipo_cbte = t.id_tipo_cbte
			AND t.compromete_factura IN (1,-1)
			AND i.Cantidad IS NULL
			AND C.FECHA >= @pFecha_Desde 
            AND C.FECHA < dateadd(dd,1,@pFecha_Hasta)


	UPDATE cbtes_items SET Imp_Gravado = 0 
			FROM cbtes_items i, cbtes c, cbtes_tipos t 
			WHERE i.id_trans = c.id_trans
			AND c.id_tipo_cbte = t.id_tipo_cbte
			AND t.compromete_factura IN (1,-1)
			AND i.Imp_Gravado IS NULL
			AND C.FECHA >= @pFecha_Desde 
            AND C.FECHA < dateadd(dd,1,@pFecha_Hasta)


   CREATE TABLE #Total (Tot DECIMAL(20,2))


   SET @sql = '     INSERT INTO #Total 
					SELECT SUM(I.Imp_gravado * t.compromete_factura) 
					   FROM cbtes c
					    JOIN  cbtes_tipos t ON c.id_tipo_cbte  = t.id_tipo_cbte And T.Compromete_Factura in (1,-1)
					    JOIN  Cbtes_items I ON I.Id_trans = C.id_trans
						JOIN  Productos P ON I.Id_Producto = P.Id_Producto
					   WHERE  C.Id_Estado_Cbte IN (1,2,4)
						   AND C.FECHA >= '''+  CONVERT(VARCHAR(8),@pFecha_Desde,112) + '''
					       AND C.FECHA < ''' + CONVERT(VARCHAR(8),DATEADD(dd,1,@pFecha_Hasta),112) + ''''
      

	IF (@pid_Sucursal <> 0 )
		SET @sql += ' AND T.Id_Sucursal = ' +  CONVERT(VARCHAR,@pid_Sucursal)

	IF (@pid_familia <> 0 )
		SET @sql += ' AND P.Id_Familia = ' +   CONVERT(VARCHAR,@pid_familia)

	IF (@pId_Proveedor <> 0)
		SET @sql += ' AND P.Id_Proveedor = ' +   CONVERT(VARCHAR,@pId_Proveedor) 

	IF (@pid_Vendedor <> '' and @pId_Vendedor <> '_')
		SET @sql += ' AND C.Id_Vendedor = ''' +   CONVERT(VARCHAR,@pId_Vendedor)  + ''''



	EXEC (@sql)

	SELECT @Venta_Total = Tot FROM #Total
    print(cast(@Venta_Total as varchar))

    CREATE TABLE #Detalle (Producto VARCHAR(14)
	,Descripcion VARCHAR(100)
	,Cantidad DECIMAL(20,2)
	,Importe DECIMAL(12,2)
	,Porcentaje DECIMAL(6,2)
	,Costo DECIMAL(16,2)
	,Renta DECIMAL(16,2)
	,Markup DECIMAL(16,2)
	)

	SET @sql = 'INSERT INTO #Detalle
		           SELECT I.Id_Producto as Producto,P.Descripcion_Detallada as Descripcion ,CAST(Sum(ISNULL(I.Cantidad,0)*T.Compromete_Factura) AS INT) 
						,sum(isnull(I.Imp_Gravado,0)*(1-C.Porc_Bonificacion/100)*isnull(t.compromete_factura,0)) as Importe
						,(sum(isnull(I.Imp_Gravado,0)*(1-C.Porc_Bonificacion/100)*isnull(t.compromete_factura,0)) / ' + CONVERT(VARCHAR,@Venta_Total) + ' * 100 )
     					,sum(isnull(I.cantidad * (isnull(P.Costo,0) * isnull(M.Cotizacion,0)) * t.compromete_factura,0))  as Costo
   					    ,sum(isnull(I.Imp_Gravado,0)*(1-C.Porc_Bonificacion/100)*isnull(t.compromete_factura,0)) - sum(isnull(I.cantidad * (isnull(P.Costo,0) * isnull(M.Cotizacion,0)) * t.compromete_factura,0)) as Renta
						,sum(isnull(I.Imp_Gravado,0)*(1-C.Porc_Bonificacion/100)*isnull(t.compromete_factura,0)) / isnull(sum(CASE ISNULL((isnull(P.Costo,0) * isnull(M.Cotizacion,0)),0) when 0 THEN 1 ELSE  (isnull(P.Costo,0) * isnull(M.Cotizacion,0)) END * isnull(I.cantidad,0) * t.compromete_factura),1) as Markup

					FROM cbtes c
					    JOIN  cbtes_tipos t ON c.id_tipo_cbte  = t.id_tipo_cbte And T.Compromete_Factura in (1,-1)
					    JOIN  Cbtes_items I ON I.Id_trans = C.id_trans
					    JOIN  Productos P	ON I.Id_Producto = P.Id_Producto 
						JOIN  Valores_Monedas M ON M.Id_Moneda = P.Id_Moneda_C 
					   WHERE  C.Id_Estado_Cbte IN (1,2,4)
						   AND C.FECHA >= '''+  CONVERT(VARCHAR(8),@pFecha_Desde,112) + '''
					       AND C.FECHA < ''' + CONVERT(VARCHAR(8),DATEADD(dd,1,@pFecha_Hasta),112) + '''' 


	IF (@pid_Sucursal <> 0 )
		SET @sql += ' AND T.Id_Sucursal = ' +  CONVERT(VARCHAR,@pid_Sucursal)

	IF (@pid_familia <> 0 )
		SET @sql += ' AND P.Id_Familia = ' +   CONVERT(VARCHAR,@pid_familia)

	IF (@pId_Proveedor <> 0)
		SET @sql += ' AND P.Id_Proveedor = ' +   CONVERT(VARCHAR,@pId_Proveedor) 

	IF (@pid_Vendedor <> '' and @pId_Vendedor <> '_')
		SET @sql += ' AND C.Id_Vendedor = ''' +   CONVERT(VARCHAR,@pId_Vendedor)  + ''''

	SET @sql +=  ' 
					GROUP BY I.Id_Producto,P.Descripcion_Detallada 
					    HAVING Sum(I.Cantidad * T.Compromete_Factura) <> 0'
					--    ORDER BY Porcentaje Desc '


	EXEC (@sql)
	SELECT * FROM #Detalle

	DROP TABLE #Total
	DROP TABLE #Detalle


END	

-- DROP TABLE #VENTAS

 /* 

CP_Ventas_por_Producto '20240801','20240831',154,0,141,''

CP_Ventas_por_Producto '20250501','20250531',33,0,0,'_'

&familia_id=33&sucursal=0&desde=20250501&hasta=20250521&Proveedor=0&Vendedor=_

ALTER  PROCEDURE [dbo].[CP_Ventas_por_Producto]
	@pFecha_Desde			DATETIME,
	@pFecha_Hasta			DATETIME,
	@pFamilia               Int,
	@pSucursal              Int,
	@pProveedor             Int,
	@pVendedor              VARCHAR(20)
select * from prod_familias4

SELECT ID_MONEDA_C,* FROM PRODUCTOS
 
UPDATE PRODUCTOS SET ID_MONEDA_C = 'PES' WHERE ID_MONEDA_C = '' OR ID_MONEDA_C IS NULL



 FIN */
